create or replace package body tbicds.PCK_USER is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*get login user record set*/
   procedure GetLoginUserRS (
      pi_vSessionID              in varchar2,
      pi_vSessionClientIP        in varchar2,
      pi_nUserID                 in number,
      pi_vKey                    in varchar2,
      pi_nFXUserID               in number,
      po_nStatusCode             out number,
      po_vStatusComment          out varchar2,
      rs                         out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_nTemp         number;
      v_nCount        number;
      v_nPatUserType  number := 32768;
      v_nRovUserTypes  number := 59;
   begin
      v_nTemp := 0;
      po_nStatusCode := 0;--0 = success
      po_vStatusComment := '';
      v_nCount := 0;

      v_vSql := 'select count(*) '
                || 'from tbicds.fx_user t1, tbicds.fx_user_rights t2 '
                || 'where t2.fx_user_id = t1.fx_user_id '
                || 'and bitand(t2.user_type, :P0) > 0 '
                || 'and t1.fx_user_id = :P1 ';
      execute immediate v_vSql into v_nCount using v_nRovUserTypes, pi_nFXUserID;
      
      --open recordset
      if v_nCount > 0 then
         --check for user account
         v_vSql := 'select t1.fx_user_id, t1.date_last_login, t1.last_login_ip, t1.last_flogin_date, t1.last_flogin_ip, '
                   || 't1.flogin_attempts, t3.User_Type, t3.user_rights, t3.read_only, t2.dims_id, '
                   || 't2.provider_id, '
                   --less than or equal to zero means we are expired!
                   || 'floor(60 - (trunc(sysdate) - t1.date_password_changed)) as days_till_expiration, '
                   || 't2.name '
                   || 'from tbicds.fx_user t1, tbicds.app_user t2, tbicds.fx_user_rights t3 '
                   || 'where t2.fx_user_id = t1.fx_user_id '
                   || 'and t3.fx_user_id = t1.fx_user_id '
                   || 'and t1.fx_user_id = :P0 ';
         open rs for v_vSql using pi_nFXUserID;
      else
         --is a patient account
         v_vSql := 'select t1.fx_user_id, t1.date_last_login, t1.last_login_ip, t1.last_flogin_date, t1.last_flogin_ip, '
                    || 't1.flogin_attempts, :P0 as User_Type, 0 as user_rights, 0 as read_only, 0 as dims_id, '
                    || ''''' as provider_id, '
                    --less than or equal to zero means we are expired!
                    || 'floor(60 - (trunc(sysdate) - t1.date_password_changed)) as days_till_expiration, '
                    || '(tbicds.fnc_utl_decstr(t2.FIRST_NAME, :P1, t2.PATIENT_ID)||'' ''||tbicds.fnc_utl_decstr(t2.LAST_NAME, :P2, t2.PATIENT_ID)) as name '
                    || 'from tbicds.fx_user t1, tbicds.patient_demographics t2 '
                    || 'where t2.fx_user_id = t1.fx_user_id '
                    || 'and t1.fx_user_id = :P3 ';
         open rs for v_vSql using v_nPatUserType, pi_vKey, pi_vKey, pi_nFXUserID;
       end if;

   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := '421 - An error occurred while retrieving user infromation, Please contact your system administrator.';
   end;

end;
/

